#!/usr/bin/python
# -*- coding: utf-8 -*-
## 1. 초기 설정① #######################################
# 라이브러리 가져오기
## 1．초기 설정 ①　모듈 가져오기 ######################
from i611_MCS import *
from teachdata import *
from i611_extend import *
from rbsys import *
from i611_common import *
from i611_io import *
from i611shm import * 

def main():
    ## 2. 초기 설정② ####################################
    # ZERO 로봇 생성자
    rb = i611Robot()
    # 좌표계의 정의
    _BASE = Base()
    # 로봇과 연결 시작 초기화
    rb.open()
    # I/O 입출력 기능의 초기화 
    IOinit( rb )
    # 교시 데이터 파일 읽기
    data = Teachdata( "teach_data" )
    ## 1. 교시 포인트 설정 ######################
    p1 = Position( -418.30, -398.86, 287.00, 0, 0, -180 )
    p2 = Position( -158.54, -395.10, 287.00, 0, 0, -180 )
    p3 = Position( -418.89, -200.35, 287.00, 0, 0, -180 )
    ## 2. 동작 조건 설정 ######################## 
    m = MotionParam( jnt_speed=10, lin_speed=100, pose_speed=100, overlap = 30 )
    #MotionParam 형으로 동작 조건 설정
    rb.motionparam( m )
    
    ## 3. 로봇 동작을 정의 ##############################
    # 작업 시작
    while True:
        
        # 시작 시간 my Tack에 저장
        myTact = time.time() 

        # 4번 Input 신호 5초 대기
        if wait( 4, '1', 5 )[0] == 1:
            dout(20,'1')
            rb.move(p1)
            

        # 5번 Input 신호 10초 대기 
        if wait( 5, '1', 10 )[0] == 1:
            dout(21,'1')
            rb.move(p2)
        # 6번 Input 신호 5초 대기 
        if wait( 6, '1', 5 )[0] == 1:
            dout(22,'1')
            rb.move(p3)

        # 7번 Input 신호 10초 대기  
        if wait( 7, '1', 10 )[0] == 1:
            dout(23,'1')
            rb.home()

        rb.sleep(2)   
        
        # 23, 22, 21, 20 Out 신호 '0'
        dout(20,'0000')
        
        # Tack Time = 종료 시간 - 시작 시간
        myTact = time.time() - myTact

        print "Tack time : ", myTact
    rb.home()

    ## 4. 종료 ######################################
    # 로봇과의 연결을 종료
    rb.close()

if __name__ == '__main__':
    main()