#!/usr/bin/python
# -*- coding: utf-8 -*-
## 1. 초기 설정① #######################################
# 라이브러리 가져오기
## 1．초기 설정 ①　모듈 가져오기 ######################
from i611_MCS import *
from teachdata import *
from i611_extend import *
from rbsys import *
from i611_common import *
from i611_io import *
from i611shm import *
import math  

def main():
    ## 2. 초기 설정② ####################################
    # ZERO 로봇 생성자
    rb = i611Robot()
    # 좌표계의 정의
    _BASE = Base()
    # 로봇과 연결 시작 초기화
    rb.open()
    # I/O 입출력 기능의 초기화 
    IOinit( rb )
    # 교시 데이터 파일 읽기
    data = Teachdata( "teach_data" )
  
    ## 1. 교시 포인트 설정 ######################
    p1 = Position(300,300,300,0,0,30)
    p1.replace(posture=7)
   
    ## 2. 동작 조건 설정 ######################## 
    m = MotionParam( jnt_speed=10, lin_speed=10, pose_speed=10, overlap = 30 )
    #MotionParam 형으로 동작 조건 설정
    rb.motionparam( m )
    
    # Tool Offset 설정
    rb.settool( 1, 0.0, 0.0, 117.0, 0.0, 0.0, 0.0 )
 
    rb.home()
    ## 3. 로봇 동작을 정의 ##############################
    # 작업 시작
    while True:
        # Tool Offset 0 : 적용 ×
        rb.changetool( 0 )  
        rb.move(p1) 
        rb.relline( dry=-90 )
        rb.relline( dry= 90 )
       
        # Tool Offset 1 : 적용 ○
        rb.changetool( 1 )
        rb.move(p1) 
        rb.relline( dry=-90 )
        rb.relline( dry= 90 )
     
    ## 4. 종료 ######################################
    # 로봇과의 연결을 종료
    rb.close()

if __name__ == '__main__':
    main()