from i611shm import shm_read
import math,os

'''Receiving data periodically from Shared memory '''

# XY Coordinate Position
data_list = shm_read(0x3000,6).split(',')  # 0 ~ 5
data  = str(float(data_list[0]) * 1000)             # X
data += "," + str(float(data_list[1]) * 1000)       # Y
data += "," + str(float(data_list[2]) * 1000)       # Z
data += "," + str(math.degrees(float(data_list[3])))# Rz
data += "," + str(math.degrees(float(data_list[4])))# Ry
data += "," + str(math.degrees(float(data_list[5])))# Rx

# XY Coordinate Posture, Multiturn
data_str = shm_read(0x3040,1) # 6
data += "," + data_str        # Posture
data_str = shm_read(0x304C,1) # 7
data += "," + data_str        # Multiturn
# Joint Degree
data_list = shm_read(0x3050,6).split(',') # 8~13
# Joint Type (1 -> revolute type, 2 -> prismatic type)
data_joint_type_list = shm_read(0x2cdc,6).split(',')

for i in range(6):
    if int(data_joint_type_list[i]) == 2:
        data += "," + str(float(data_list[i]) * 1000)           # prismatic type
    else :
        data += "," + str(math.degrees(float(data_list[i])))    # revolute type

# Singular Point, Speed Limit, Soft Limit
data_str = shm_read(0x3048,1) # 14
data += "," + data_str        # Singular Point
data_str = shm_read(0x3098,1) # 15
data += "," + data_str        # Speed Limit
data_str = shm_read(0x309C,1) # 16
data += "," + data_str        # Soft Limit

# System SI
data_str = shm_read(0x0300,1)   # 17
                                # Servo Status / EMS status / System error(C..) / ABS lost status 
                                # OFF : 0      / OPEN : 0   / NO ERR : 0        / NO ERR : 0
data += "," + data_str

data_str = shm_read(0x0308,1)   # 18
                                # Robot Program status / System error(E..) / Pause status / System error(C,E) / System Status / Error Code
data += "," + data_str

data_str = shm_read(0x0104,1)   # 19  Arm Input 0 ~ 15 , Arm Output 16 ~ 31(address = 32 ~ 63)
                                # 8bytes type(1L = Arm Input, 1H = Arm Output) ->  7 = 00000000 00000000 00000000 00000111
                                #                                                      [     1   H     ] [     1   L     ]
                                # print     0  0  0  0  0  0  0  0       0  0  0  0  0  0  0  0       0  0  0  0  0  0  0  0       0  0  0  0  0  0  0  0
                                # address   63 62 61 60 59 58 57 56      55 54 53 52 51 50 49 48      47 46 45 44 43 42 41 40      39 38 37 36 35 34 33 32
                                # Arm   OUT:16 15 14 13 12 11 10 9       8  7  6  5  4  3  2  1    In:16 15 14 13 12 11 10 9       8  7  6  5  4  3  2  1
data += "," + data_str

data_str = shm_read(0x2C00,1)   # 20 Manipulator Type Information

data += "," + data_str

data_str = shm_read(0x2C24,1)   # 21 Manipulator Serial Number Information

data += "," + data_str

fVer = "/opt/i611/version"
fBuild = "/opt/i611/build"

f1 = open(fVer, 'r')
data_str = f1.read()
f1.close()
data += "," + data_str[:-1]     # 22 Robot System Version Information

f2 = open(fBuild, 'r')
data_str = f2.read()
f2.close()
data += "," + data_str[:-1]     # 23 Robot System Build Information


# append status monitoring for teach mode control		# CT210121
data_str = shm_read(0x010E,1)   # 24 IN_R(L)        7       6       5       4       3       2       1       0
data += "," + data_str          #                   ACPF    DCPF    RMT-ER  EMS-ER  SVON-ER WDER    ID1     ID0

data_str = shm_read(0x010F,1)   # 25 IN_R(H)        7       6       5       4       3       2       1       0
data += "," + data_str          #                   -       MODE2   MODE1   EMS2    EMS1    SVON2   SVON1   ENABLE

data_str = shm_read(0x0114,1)   # 26 IN_X1          7       6       5       4       3       2       1       0
data += "," + data_str          #                   -       -       -       PLC_ER  OH3     OH2     OH1     ID2

data_str = shm_read(0x0115,1)   # 27 IN_X2          7       6       5       4       3       2       1       0
data += "," + data_str          #                   MODE2   MODE1   DOOR2   DOOR1   JOG_TCH JOG_RMT -       ID3

data_str = shm_read(0x0110,1)   # 28 OUT_R(L)       7       6       5       4       3       2       1       0
data += "," + data_str          #                   -       -       LED2    LED1    READY   SVEN    HS_EN2  HS_EN1

data_str = shm_read(0x0100,1)   # 29 D_IN(1~16) , D_OUT(17~32)
data += "," + data_str

data_str = str(os.path.exists("/tmp/zeus_teach"))
data += "," + data_str

data_str = shm_read(0x0140,1)   # 31 external Input 512~543 (32bit)
data += "," + data_str

data_str = shm_read(0x0160,1)   # 32 external Output 768~799 (32bit)
data += "," + data_str

data += ","
print(data)     # Get print result as stdout of SSH and use it.

