#!/usr/bin/python
# -*- coding: utf-8 -*-
## 1. 초기 설정① #######################################
# 라이브러리 가져오기
## 1．초기 설정 ①　모듈 가져오기 ######################
from i611_MCS import *
from teachdata import *
from i611_extend import *
from rbsys import *
from i611_common import *
from i611_io import *
from i611shm import * 

def main():
    ## 2. 초기 설정② ####################################
    # ZERO 로봇 생성자
    rb = i611Robot()
    # 좌표계의 정의
    _BASE = Base()
    # 로봇과 연결 시작 초기화
    rb.open()
    # I/O 입출력 기능의 초기화 
    IOinit( rb )

    # 교시 데이터 파일 읽기
    data = Teachdata( "teach_data" )

    ## 1. 교시 포인트 설정 ######################
    p1 = Position( -418.30, -398.86, 287.00, 0, 0, -180 )
    p2 = Position( -158.54, -395.10, 287.00, 0, 0, -180 )
    ## 2. 동작 조건 설정 ######################## 
    m = MotionParam( jnt_speed=10, lin_speed=10, pose_speed=10, overlap = 30 )
    #MotionParam 형으로 동작 조건 설정
    rb.motionparam( m )
    # dout 초기화
    dout(21,'0000')
    
    # MDO SET 
    rb.set_mdo( mdoid=1, portno=21, value=1, kind=1, distance=30 )
    rb.set_mdo( mdoid=8, portno=21, value=0, kind=2, distance=50 )

    ## 3. 로봇 동작을 정의 ##############################
    # 작업 시작
    while True:
        rb.move(p1) 
        # Mdo 시작
        rb.enable_mdo(129)
        # Mdo Move 
        rb.move(p2)
        # Mdo 종료
        rb.disable_mdo(129)
        # 16 Output '0' 초기화
        dout(21,'0')

    ## 4. 종료 ######################################
    # 로봇과의 연결을 종료
    rb.close()

if __name__ == '__main__':
    main()