#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Created on Fri Aug 14 16:49:50 2020
@author: user
"""

import json  
import os, sys  
import copy
from collections import OrderedDict
import io 

# json file address 
file_address  = '/home/i611usr/'
Teaching_data = OrderedDict() 
Limit_USize   = 10
Limit_TSize   = 100  
"""
Teaching Data format
   1.version 
   2.baseoffset
   3.tool_offset
   4.Teaching data 
     4.1 array_size 
     4.2 Teaching data information 
"""

Teaching_data = OrderedDict()

Teaching_data = {
 "version" : 100.0,
 "tool_offset":[{

  }],
 "frame_offset":[{
  }],
 "teach_data" : [{
 }],
}

""" 
Make Teaching data format
   init_name: teaching name 
    1.type       : "pos","joint","pulse" type set
    2.init_flag  : Check if data is registered 
    3.datetime   : teaching data save date
    4.pos_data   : position data
    5.joint_data : joint data
    6.pulse_data : pulse data
""" 
update_teaching = {
    "idx" : 1,
    "PositionName" : "pickup1",
    "Position Name" : "pickup1 [0]",
    "Array" : 0,
    "DataType" : 1,
    "Replace" : 0,
    "DateTime" : "0",
    "PosX" : 2.0,
    "PosY" : 0.0,
    "PosZ" : 0.0,
    "PosRz" : 0.0,
    "PosRy" : 0.0,
    "PosRx" : 0.0,
    "PosPosture" : 0,
    "PosMulti" : 0,
    "Jnt1" : 1.0,
    "Jnt2" : 2.0,
    "Jnt3" : 3.0,
    "Jnt4" : 4.0,
    "Jnt5" : 5.0,
    "Jnt6" : 6.0,
    "Pls1" : 3,
    "Pls2" : 0,
    "Pls3" : 0,
    "Pls4" : 0,
    "Pls5" : 0,
    "Pls6" : 0,
    "VarInt" : 0,
    "VarFloat" : 0.0,
    "FrameNo" : 0,
    "ToolNo" : 0,
    "RobotNo" : 1,
    "Description" : ""
}

update_Base ={
    "idx" : 1,
    "OfsX" : 0.0,
    "OfsY" : 0.0,
    "OfsZ" : 0.0,
    "OfsRz" : 0.0,
    "OfsRy" : 0.0,
    "OfsRx" : 0.0,
    "RobotNo" : 1,
    "Description" : ""
}

update_Tool = {
    "idx" : 1,
    "OfsX" : 0.0,
    "OfsY" : 0.0,
    "OfsZ" : 0.0,
    "OfsRz" : 0.0,
    "OfsRy" : 0.0,
    "OfsRx" : 0.0,
    "RobotNo" : 1,
    "Description" : ""
}

empty = {
}
# Json file check exists file or New file 
def file_check(fname):
    """ 
    file basic address, json file 
        '/home/i611usr/' + Json file name
    """
    address = file_address + fname

    """ 
    Read Json file check
        1. exists Json file
        2. make Json file 
    """
    if os.path.exists(address): 
        exists_fileopen(address)
    else:
        new_fileopen(address) 

# limit teaching data size 1000ea 
def Limit_Tsize(teaching_list):
    total_list = 0 
    for j in range(len(teaching_list)):
        if teaching_list[j]  == 0:
            total_list = total_list +1
        else:
            total_list = total_list + teaching_list[j] 

    if total_list > Limit_TSize:
        print '3003'
        sys.exit() 

def Name_Check(Name_list): 
    if len(Name_list) != len(set(Name_list)): 
        print '3004'
        sys.exit() 

# Make Teaching Json file 
def new_fileopen(name):
    teaching_name = []
    teaching_type = [] 
    teaching_list = []

    # Python Teaching Name Extraction
    teaching_name, teaching_type, teaching_list = ptarget_open(name)
    teaching_len  = len(teaching_name)

    # Make New Json file 
    make_teach_data(teaching_name, teaching_type, teaching_len, name, teaching_list)
    print '3001'
# exist Teaching file Save
# parm1 json address
def exists_fileopen(address):
    # read new teaching name
    teaching_type = []  
    teaching_name = [] 
    teaching_list = []
    teaching_name, teaching_type, teaching_list = ptarget_open(address)
    """
    old and new teaching name compare and save
       1. parm1 enmae: json file address ('/home/i611usr/ + json file')
       2. parm2 teaching_name: python teaching name
       3. parm3 teaching_name: teaching type 
    """

    compare_teachingdata(address, teaching_name, teaching_type, teaching_list)
    print '3001' 
""" 
new make teaching data
   1.nlist: teaching name list
   2.count: teaching data count 
   3.fname: make file name Json
   4.dlist: teachind data list count
""" 
def make_teach_data(nlist, ttype, count, fname, dlist): 
    Tlist = 0 
    Ulist = 0
   
    # set init teaching data
    for k in Teaching_data["tool_offset"]:
        k.update(update_Tool)
    
    for j in Teaching_data["frame_offset"]:
        j.update(update_Base)
    
    # make Tool offset
    for t in range(2,9):
        #update_Tool["idx"] = str(t)
        update_Tool["idx"] = int(t)
        Teaching_data['tool_offset'].append(update_Tool.copy())  

    # make Base offset
    for b in range(2,9):
        #update_Base["idx"] = str(b)
        update_Base["idx"] = int(b)
        Teaching_data['frame_offset'].append(update_Base.copy())  
    
    # make Teaching data 
    for Clist in range(count):
        # 1st data check 
        if Clist == 0:
            # 처음 데이터가 list일 경우 
            if int(dlist[Clist]) != 0:  
                for i in Teaching_data["teach_data"]:
                    update_teaching["idx"]           = 1 
                    update_teaching["PositionName"]  = nlist[Clist]
                    update_teaching["DataType"]      = int(ttype[Clist])
                    update_teaching["Position Name"] = nlist[Clist] + " [0]"
                    
                if int(dlist[Clist]) == 0:
                    update_teaching["Array"]     = 0
                else:
                    update_teaching["Array"]     = 0     
                i.update(update_teaching)  
                # update file add
                for j in range(int(dlist[Clist])-1):
                    # update teaching name and foramt 
                    update_teaching["PositionName"] = nlist[Clist]
                    update_teaching["DataType"]     = int(ttype[Clist]) 
                    update_teaching["idx"]          = j + 2             # idx 증가
                    update_teaching["Array"]        = j + 1
                    update_teaching["Position Name"] = nlist[Clist] + " ["+str(j+1)+"]"
                    Teaching_data["teach_data"].append(update_teaching.copy())
                Tlist = int(dlist[Clist]) 
            
            else:
                Ulist = 1
                for i in Teaching_data["teach_data"]:
                    update_teaching["idx"]           = Ulist  
                    update_teaching["PositionName"]  = nlist[Clist]
                    update_teaching["DataType"]      = int(ttype[Clist]) 
                    update_teaching["Array"]     = 0
                    update_teaching["Position Name"] = nlist[Clist] + " [0]"
 
                i.update(update_teaching)  
        else: 
            if int(dlist[Clist]) == 0:
                Ulist = Ulist + 1 
                # update teaching name and foramt 
                update_teaching["PositionName"] = nlist[Clist]
                update_teaching["DataType"]     = int(ttype[Clist]) 
                update_teaching["idx"]          = Tlist + Ulist 
                update_teaching["Array"]        = 0
                update_teaching["Position Name"] = nlist[Clist] + " [0]"
                Teaching_data['teach_data'].append(update_teaching.copy()) 
                
            else:
                # Total List Value
                for k in range(int(dlist[Clist])):
                    update_teaching["PositionName"] = nlist[Clist]
                    update_teaching["DataType"]     = int(ttype[Clist]) 
                    update_teaching["idx"]          = k  + Ulist  + Tlist + 1 
                    update_teaching["Array"]        = k
                    update_teaching["Position Name"] = nlist[Clist] + " ["+str(k)+"]"
                    Teaching_data['teach_data'].append(update_teaching.copy())
                
                # List 마지막 데이터 위치 저장
                Tlist = Tlist  + int(dlist[Clist])  

    with open(fname,'w') as make_file:
        json.dump(Teaching_data, make_file, indent=4,sort_keys=True, ensure_ascii=False) 
        
# Pyhon file Open and search Target Name
# parm1 json address 
def ptarget_open(ntarget): 
    target_name  = []
    target_type  = []
    target_list  = []
    line_check   = []
    Search_Teach = ["ZeusTeach()"]
    Teach_Flage  = 0 
    Search_Name  = [".TUndef(",".TPosition(",".TJoint(",".TPulse(",".TInt(",".TFloat("]
    _type        = "0"
    teachline    = []
    tempstr     = ""
    """ 
    Pyhon name Extraction 
    """ 
    with open(ntarget + '.py') as file:
        while True:
            # user python read line All
            line    = file.readline()
            tempstr = line
            tempstr = tempstr.replace(" ","")

            if tempstr != "":   # 문장의 끝이 아닌 경우
                if tempstr[0] != "#":
                    if 'ZeusTeach()' in line:
                        if '#' in line:
                            check_front = line.find('#')
                            check_back  = line.find('ZeusTeach()')

                            # 기능 사용하지 않음 ex) # ZEUSTeach()
                            if check_front < check_back:
                                break

                            # ex) ZEUSTeach() # 티칭 데이터
                            else:
                                Teach_Flage = 1
                                break
                        else:
                            Teach_Flage = 1
                            break

                    if not line: break
            else:
                break

        if Teach_Flage == 1:

            while True:
                # user python read line All
                line = file.readline()

                for j in range(6):
                    line_check  = line.find(Search_Name[j])
                
                    if line_check != -1:  
                        if '#' in line:  
                            check_front = line.find('#')
                            check_back  = line.find('.')

                            if check_front < check_back: 
                                break
                            else:
                                line = line[0:check_front-1] 
                                # data type save
                                if '.TUndef(' in line:      # undef
                                    _type = '0'
                                elif '.TPosition(' in line: # Postion
                                    _type = '1' 
                                elif '.TJoint(' in line:    # Joint 
                                    _type = '2'
                                elif '.TPulse(' in line:    # Pulse
                                    _type = '3'
                                elif '.TInt(' in line:      # Int
                                    _type = '4'
                                elif '.TFloat(' in line:    # Float    
                                    _type = '5' 

                                target_type.append(_type)
                                target_name.append(make_teachFileName(line))
                                target_list.append(make_ListSet(line))
                        else:
                            # data type save
                            if '.TUndef(' in line:      # undef
                                _type = '0'
                            elif '.TPosition(' in line: # Postion
                                _type = '1' 
                            elif '.TJoint(' in line:    # Joint 
                                _type = '2'
                            elif '.TPulse(' in line:    # Pulse
                                _type = '3'
                            elif '.TInt(' in line:      # Int
                                _type = '4'
                            elif '.TFloat(' in line:    # Float    
                                _type = '5' 

                            target_type.append(_type)
                            target_name.append(make_teachFileName(line))
                            target_list.append(make_ListSet(line))
                if not line: break  #: line end break

        elif Teach_Flage == 0:
            # Name error 
            print '3004'
            sys.exit() 
    # Teaching data size check 300
    Limit_Tsize(target_list)
    # Same Name check
    Name_Check(target_name)
    return target_name, target_type, target_list

def make_ListSet(Target_line):
    ListIndex   = Target_line.find("(")
    target_list = Target_line[int(ListIndex):]
    target_list = target_list.strip()

    # remove '()'
    target_list = target_list.replace('(','')
    target_list = target_list.replace(')','')
    
    # 0일 경우
    if target_list == '':
        target_list = 0

    else:
        target_list = int(target_list) 
        # List 1일 경우 0으로 변경
        if target_list == 1:
            pass
            #target_list = 0 

        # 100 이상일 경우 
        elif target_list > Limit_USize:
            print '3002'
            sys.exit()  

        #음수일 경우         
        elif target_list < 0:
            target_list = 0 

    return  target_list

def make_teachFileName(Target_line):
    # search "=" string
    index       = Target_line.find("=")
    target_name = Target_line[:int(index)]

    # remove the Blank 
    target_name  = target_name.strip()
    return target_name 

def get_infoJson(json_address):

    _tname  = []
    _type   = []
    _list   = []
    _index  = []
 
    _Fname = []
    _Ftype = []
    _Flist = [] 
    _Ltype = 0 

    # json data save
    with open(json_address,'r') as make_file: 
        json_data = json.load(make_file)  

        # Get teaching name 
        for k in json_data["teach_data"]: 
            
            # Old data check
            if k.has_key('PositionName'): 
                _tname.append(k["PositionName"]) 
                _type.append(k["DataType"]) 
                _list.append(k["Array"])   
                _index.append(k["idx"])

            # data 없을 경우 
            else: 
                _index =[0]    

    # name 중복 삭제 
    _Fname = OrderedDict.fromkeys(_tname).keys()

    for j in range(len(_Fname)):
        _Ltype = _tname.index(_Fname[j])
        _Ftype.append(_type[_Ltype])

        # List 1일경우 0으로 변경
        #if _tname.count(_Fname[j]) == 1: 
        if _list[_Ltype] == -1:
            # 変数ならば 0 をセット
            set_List = 0
        else: 
            set_List = _tname.count(_Fname[j])  
            
        _Flist.append(set_List)

        # 100 이상일 경우 
        if set_List > Limit_USize:
            sys.exit()  

        #음수일 경우         
        elif set_List < 0:
            set_List = 0 
    # unicode encodeing 
    _Fname  = [s.encode('utf-8') for s in _Fname]  
    return _Fname ,_Ftype, _Flist, _index,  json_data

def NewList_Check_Type(NewData, OldData):
    
    Check_Name = [ ]
    Check_list = [ ]
    Check_Type = [ ]
    
    # Check LIST, Type
    for key in NewData:
        try:
            # type만 다름 
            if NewData[key][0] != OldData[key][0]:
                Check_Name.append(key)
                Check_Type.append(NewData[key][0])
                Check_list.append(NewData[key][1])
        except: 
            pass 
    return Check_Name, Check_list, Check_Type  

def NewList_Check_List(NewData, OldData):
    Check_Name = []
    Check_list = []
    Check_Type = []

    # Check LIST, Type
    for key in NewData:
        try:
            # 리스트 크기만 다름
            # print("NewData:{}".format(NewData[key][1]))
            # print("OldData:{}".format(OldData[key][1]))
            if NewData[key][1] != OldData[key][1]:
                Check_Name.append(key)
                Check_Type.append(NewData[key][0])
                Check_list.append(NewData[key][1])
        except:
            pass
    return Check_Name, Check_list, Check_Type

def Append_teachingData(NameAdd, listAdd, TypeAdd, old_dict, json_data):
    T_Count = 0
    C_Count = 0
    for c in range(len(NameAdd)):
        C_Count = c + 1
        cur_length = listAdd[c]
        old_length = old_dict[NameAdd[c]][1]
        diff = cur_length - old_length
        
        # 각 PositionName 데이터의 최대 idx 구함
        max_idx = 0
        for index, k in enumerate(json_data["teach_data"]):
            if NameAdd[c] == k["PositionName"]:
                if max_idx < k['idx']:
                    max_idx = k['idx']

        # print('max_idx:', max_idx)
        # print("diff: {}".format(diff))
        # print("old_length: {}".format(old_length))
        # print("cur_length: {}".format(cur_length))
        if diff > 0:  # 현재 리스트 길이가 더 긴 경우, 추가된 길이만큼 append
            if old_length == 0:
                diff -= 1
                old_length += 1
                max_idx += 1
            for i in range(diff):
                T_Count = old_length + i
                update_teaching["idx"]           = max_idx+i
                update_teaching["PositionName"]  = NameAdd[c]
                update_teaching["Position Name"] = NameAdd[c] + " [" + str(T_Count) + "]"
                update_teaching["DataType"]      = TypeAdd[c]
                update_teaching['Array']         = T_Count
                json_data['teach_data'].append(update_teaching.copy())

        elif diff < 0:  # 현재 리스트 길이가 더 짧은 경우, 제거
            if cur_length == 0:
                diff += 1
            for i in range(abs(diff)):
                for index, k in enumerate(json_data["teach_data"]):
                    if NameAdd[c] == k["PositionName"]:
                        if max_idx == k["idx"]:
                            del json_data["teach_data"][index]
                            max_idx -= 1

    return json_data

def AddNew_teachingData(NameAdd, listAdd, TypeAdd, IdxAdd, json_data):
    T_Count = 0 
    C_Count = 0 

    # {} None일 경우 
    for k in json_data["teach_data"]: 
        if not k.has_key('PositionName'):  
            for index, k in enumerate(json_data["teach_data"]): 
                del json_data["teach_data"][index]
                
    for c in range(len(NameAdd)):
        C_Count = c + 1   

        if listAdd[c] == 0:     
            update_teaching["idx"]           = C_Count + IdxAdd  
            update_teaching["PositionName"]  = NameAdd[c]  
            update_teaching["DataType"]      = TypeAdd[c] 
            update_teaching['Array']         = 0
            json_data['teach_data'].append(update_teaching.copy())  

        # list exisit 
        else:   
            for j in range(listAdd[c]):
                T_Count = j  
                update_teaching["idx"]           = C_Count  + T_Count + IdxAdd
                update_teaching["PositionName"]  = NameAdd[c]  
                update_teaching["DataType"]      = TypeAdd[c] 
                update_teaching['Array']         = j
                json_data['teach_data'].append(update_teaching.copy())  

            IdxAdd = T_Count + IdxAdd
        
    return json_data 

def Delete_teachingData(delete, old_dict ,json):
    for j in delete:
        for index, k in enumerate(json["teach_data"]): 
            if int(old_dict[j][1]) ==0: 
                if k["PositionName"] == j:
                    del json["teach_data"][index]
            else:
                for f in range(int(old_dict[j][1])):   
                    if k["PositionName"] == j:
                        del json["teach_data"][index]
    if not json["teach_data"]:
        json["teach_data"].append(empty)
    
    return json 

def Change_single_teachingData(json_data):
    for index, k in enumerate(json_data["teach_data"]):
        if k["Array"] == -1:
            json_data["teach_data"][index]["Array"] = 0
            json_data["teach_data"][index]["Position Name"] += " [0]"

    return json_data

def Idx_Alignment(json,_tname,_list):
    TName  = [ ]
    index  = 1 
    tcount = 0 
    tsize  = len(_tname)
    lcount = 0 
   
    for j in _tname: 
        for k in json["teach_data"]:  
            if k["PositionName"] == j:
                k["idx"] = index 
                index = index + 1

def compare_teachingdata(_address, _tname, _type, _list):

    _newTname = [ ] 
    _newType  = [ ]
    _newList  = [ ]

    _oldTname = [ ] 
    _oldType  = [ ]
    _oldList  = [ ]
    _oldIndex = [ ]
    

    _add_name  = [ ]
    _add_type  = [ ]
    _add_list  = [ ]
    _add_idx   = 0  

    _updateTname = [ ] 
    _updateType  = [ ]
    _delete_name = [ ]  

    new_dict      = {}
    old_dict      = {}

    json_data  = OrderedDict()  
    
    _newTname = _tname 
    _newType  = _type 
    _newList  = _list 

    CName = []
    CList = []
    CType = []
 
    # get old_name, Type, Json data
    _oldTname, _oldType, _oldList, _oldIndex, json_data = get_infoJson(_address)

    # make dictionary old,new
    for j in range(len(_newTname)):
        new_dict.setdefault(_newTname[j], []) 
        new_dict[_newTname[j]].append(int(_newType[j]))
        new_dict[_newTname[j]].append(int(_newList[j])) 

    for j in range(len(_oldTname)):
        old_dict.setdefault(_oldTname[j], []) 
        old_dict[_oldTname[j]].append(int(_oldType[j]))
        old_dict[_oldTname[j]].append(int(_oldList[j])) 
    
    for new in _newTname:
        try:
            _oldTname.index(new)
        except ValueError:
            _add_name.append(new)
            _add_type.append(int(new_dict[new][0]))
            _add_list.append(int(new_dict[new][1]))
     
    # delete Teaching Name
    for now in _oldTname:
        try:
            _newTname.index(now)
        except ValueError:
            _delete_name.append(now)

    ####### add Teaching data 
    if _add_name:  
        _add_idx  = _oldIndex[len(_oldIndex)-1]
        json_data = AddNew_teachingData(_add_name, _add_list, _add_type, _add_idx, json_data)

    ####### delete Teaching data
    if _delete_name: 
        ####### name the same but list, type different
        json_data = Delete_teachingData(_delete_name, old_dict, json_data)

    json_data = Change_single_teachingData(json_data)

    ####### Type Check (데이터 이름은 동일하나, 타입이 변경된 경우)
    CName, CList, CType = NewList_Check_Type(new_dict, old_dict)

    ####### Change Type update
    if CName:
        ###### Change Type Delete
        json_data = Delete_teachingData(CName, old_dict, json_data)
        ###### Make Add teaching data
        json_data = AddNew_teachingData(CName, CList, CType, 0, json_data) 

    # 타입 변경 없는 경우, 리스트 크기만 체크
    else:
        ####### List Check (데이터 이름, 타입 동일하나, 리스트 크기가 변경된 경우)
        CName = []
        CList = []
        CType = []
        CName, CList, CType = NewList_Check_List(new_dict, old_dict)

        # print("CName:", CName)
        # print("CList:", CList)
        # print("CType:", CType)


        ####### Change List update
        if CName:
            json_data = Append_teachingData(CName, CList, CType, old_dict, json_data)

    ###### idx Alignment
    Idx_Alignment(json_data,_tname,_list)

    ###### update json file 
    with open(_address,'w') as make_file:
        json.dump(json_data, make_file, indent=4,sort_keys=True) 

def main(argv):
    # argv file name
    if len(argv) > 1:
        file_check(argv[1])
    else:
        print("3005")

if __name__ == "__main__":
    main(sys.argv) 