# -*- coding: utf-8 -*-
from i611shm import *
from rblib import Robot
import os
import sys
import time
import socket
import threading
import datetime
import subprocess
import logging
import logging.handlers

VERSION = [1, 0, 1, 7]

# region logger setting
logformat = '----------------------------------------\n%(message)s\n'
FILE_PATH_LOG = "/opt/i611/log/socket_checker_log"
MAX_BYTES = 1024 * 1024 * 10       # 10MB
logger    = logging.getLogger()
formatter = logging.Formatter(logformat)

logger.setLevel(logging.INFO)
streamHandler = logging.StreamHandler()
fileHandler  = logging.handlers.RotatingFileHandler(filename= FILE_PATH_LOG,maxBytes = MAX_BYTES, backupCount = 10)

streamHandler.setFormatter(formatter)
fileHandler.setFormatter(formatter)

logger.addHandler(fileHandler)
logger.addHandler(streamHandler)

os.system("sudo chmod 644 %s"%FILE_PATH_LOG)
# endregion

DEFAULT_DISCONNECT_THRESHOLD = 4

class socket_checker(object):
    def version(self):
        return "%(prog)s {}".format(".".join([str(i) for i in VERSION]))

    def __init__(self, _argv):

        
        self.hostname = _argv[1]
        self.__logsock = socket.socket(socket.AF_UNIX, socket.SOCK_DGRAM)
        self.__lock = threading.Lock()
        self.__rblib = Robot("192.168.0.23", 12345)
        self.msg = ""

        if os.path.exists(FILE_PATH_LOG):
            pass
            # os.remove(FILE_PATH_LOG)
            # for log file backup
            # os.rename(FILE_PATH_LOG,LOG_SAVE_PATH+"_"+self.get_time())


        # region Cause Critical Error
        self.indicator_data = None

        # Status value
        self.SS_TEACH      = 4  # teach mode
        self.SS_CON_ERR     = 9  # connection error
        self.SS_NERR        = 10 # normal error
        self.SS_CERR        = 11 # critical error

        self.ret_status = {
            "python_error":0,
            "Ping_OK":1,
            "Ping_NG":2
        }

        self.FONT7SEG = {          ## 7seg font
            '0':0x40, # , # 0
            '1':0x79, # , # 1
            '2':0x24, # , # 2
            '3':0x30, # , # 3
            '4':0x19, # , # 4
            '5':0x12, # , # 5
            '6':0x02, # , # 6
            '7':0x78, # , # 7
            '8':0x00, # , # 8
            '9':0x10, # , # 9
            'A':0x08, # , # A
            'B':0x03, # , # B
            'C':0x27, # , # C
            'D':0x21, # , # D
            'E':0x06, # , # E
            'F':0x0e, # , # F
            'G':0x10, # , # G
            'H':0x0b, # , # H
            'I':0x7b, # , # I
            'J':0x61, # , # J
            'K':0x0a, # , # K
            'L':0x47, # , # L
            'M':0x48, # , # M
            'N':0x2b, # , # N
            'O':0x23, # , # O
            'P':0x0c, # , # P
            'Q':0x18, # , # Q
            'R':0x2f, # , # R
            'S':0x12, # , # S
            'T':0x07, # , # T
            'U':0x63, # , # U
            'V':0x41, # , # V
            'W':0x01, # , # W
            'X':0x09, # , # X
            'Y':0x11, # , # Y
            'Z':0x64, # , # Z
            '-':0x3f, # , # -
            }
        
        self.SS_7seg = ("---","INI","RDY","INC","TCH","JOG","RUN","PAU","","CON",
                        "E%02d","C%02d","U%02d","R%02d")
        # endregion
    
    ################################################################################################################
    # log part
    def get_time(self):
        return datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S,%f')[:-3]
    # append message in self.msg
    def append_log(self, message):
        self.msg = self.msg + message
    
    def print_log(self):
        self.append_log("print_time : %s"%self.get_time())
        logger.info(self.msg)
        self.msg = ""

        # with open(FILE_PATH_LOG,'a') as f:
        #     self.append_log("print_time : %s\n"%self.get_time())
        #     f.write(self.msg)
        # self.msg = ""

    ################################################################################################################
    # connection checking part
    # 파일내부에 설정된 threshold 값 읽어오기. 읽는 것이 불가능 하면 default값 리턴
    def get_threshold(self):
        self.disconnect_threshold_filename = "/opt/i611/tools/socket_checker_disconnect_threshold"
        threshold_num = DEFAULT_DISCONNECT_THRESHOLD
        try:
            if os.path.exists(self.disconnect_threshold_filename):
                with open(self.disconnect_threshold_filename, 'r') as f:
                    threshold_num = int(f.readline())
                    self.append_log("Set_threshold : %d\n"%threshold_num)
        except Exception as e:
            self.append_log("Exception get_threshold() : \n %s\n"%str(e))
        finally:
            return threshold_num
    

    # ping으로 연결을 확인 - 연결이 안되는 횟수를 리턴
    def connection_checking(self):
        # threshold 값 파일로부터 읽어오기 없으면 default 값 설정
        self.disconnect_threshold = self.get_threshold()
        disconnect_count = 0

        self.append_log("Ping target : %s\n"%self.hostname)
        try:
            while disconnect_count < self.disconnect_threshold:  # 연결 실패 카운트가 기준 범위 내인 경우
                # ping
                self.response = subprocess.call(["ping","-c","1","-w","1",self.hostname])
                if self.response == 0:  # Ping OK
                    break
                else: # Ping FAIL
                    disconnect_count += 1
                    self.append_log( "Ping : [NG] disconnect_count : %d\n"%disconnect_count )

                    if self.is_teach_mode():  # Teach 모드인 경우, abortm() 호출
                        # open rblib
                        ret = self.__rblib.open()
                        self.append_log( "rblib.open : %s\n"%str(ret) )

                        # acquire permission (임시. permission 취득 없이 abortm 을 수행하기 위해서는 MCS 수정 필요)
                        ret = self.__rblib.acq_permission()
                        self.append_log( "rblib.acq_permission : %s\n"%str(ret) )

                        # abort motion
                        ret = self.__rblib.abortm()
                        self.append_log( "rblib.abortm :%s\n"%str(ret) )

                        # release permission (임시. permission 취득 없이 abortm 을 수행하기 위해서는 MCS 수정 필요)
                        ret = self.__rblib.rel_permission()
                        self.append_log( "rblib.rel_permission : %s\n"%str(ret) )

                        # close rblib
                        ret = self.__rblib.close()
                        self.append_log( "rblib.close : %s\n"%str(ret) )

        except Exception as e:
            self.append_log("Exception connection_checking() : \n %s\n"%str(e))
        finally:
            return disconnect_count

    ################################################################################################################
    # setting checking part
    def is_teach_mode(self):
        try:
            # 컨트롤러가 Teach 모드인지 확인
            self.__rblib.open()
            ret = self.read_memory_io_word(130)
            self.__rblib.close()

            if ret[0]:
                seg = (ret[1] >> 4) & 0x0F
                if seg == self.SS_TEACH:
                    ret_val = True
                else:
                    ret_val = False
            else:
                ret_val = False

        except Exception as e:
            ret_val = False
        finally:
            return ret_val    
    ################################################################################################################
    # main part
    def run(self):
        return_value = self.ret_status["python_error"]
        self.append_log( "start_time : %s\n"%self.get_time() )

        try:
            # 연결 실패 횟수를 반환 threadhold 값 이하면 정상, 초과하면 비정상
            self.disconnect_count = self.connection_checking()            
            
            if self.disconnect_count >= self.disconnect_threshold:  # 연결 실패 카운트가 기준 범위를 초과한 경우
                ##########################################################################################
                # kill i611sys.py part
                # check i611sys.py is running
                self.append_log( "Ping : [NG] Over threshold value\n" )
                ret = os.system("ps | grep i611sys.py | grep -v grep")
                if ret == 0:  # 실행 중인 경우
                    self.append_log( "i611sys.py is running\n" )
                    # kill i611sys
                    os.system("sudo kill -9 $(ps | grep i611sys.py | grep -v grep | awk '{print $1}')")
                    self.append_log( "kill i611sys\n" )
                    # wait for kill
                    time.sleep(1)
                else :
                    self.append_log( "i611sys.py is not running\n" )
                
                ##########################################################################################
                # change 7seg part
                # open rblib
                ret = self.__rblib.open()
                self.append_log( "rblib.open : %s\n"%str(ret) )

                # cause critical error + change svsts to ERROR about native
                ret = self.cause_critical_error(7, "Teaching Pendant has been disconnected.")
                if ret == False:
                    raise Exception("cause_critical_error() failed.")
                else:
                    self.append_log( "cause_critical_error : %s\n"%str(ret) )
                
                return_value = self.ret_status["Ping_NG"]

                # close rblib, deactivate asyncm
                ret = self.__rblib.acq_permission()
                self.append_log( "rblib.acq_permission() : %s\n"%str(ret) )
                ret = self.__rblib.asyncm(2)
                self.append_log( "rblib.asyncm(2) : %s\n"%str(ret) )
                ret = self.__rblib.rel_permission()
                self.append_log( "rblib.rel_permission() : %s\n"%str(ret) )
                ret = self.__rblib.close()
                self.append_log( "rblib.close : %s\n"%str(ret) )
            else:
                self.append_log( "Ping : [OK]\n" )
                return_value = self.ret_status["Ping_OK"]

        except Exception as e:
            self.append_log( "Exception : "+ e +"\n" )
            return_value = self.ret_status["python_error"]
        finally:
            self.print_log()
            return return_value


    ################################################################################################################
    # critical error part
    # region Cause Critical Error
    def cause_critical_error(self, err_code, err_msg=""):
        try:
            # self.write_memory_io_word(128,0xFFFF63F4,0xFFFF00FB)  # C99

            # output log
            error_msg = str(err_code) + "," + err_msg
            self.status_log("CERR", error_msg)

            # output memory I/O
            st = (self.SS_CERR << 4) # critical error
            st |= (err_code&0x0FF) << 8
            self.write_memory_io_word(130,st,0xFFFF000F)
            # print(self.SS_CON_ERR)

            # output 7seg
            self.indicator_data = self.generate_indicator_data(self.SS_CON_ERR, err_code)
            self.write_memory_io_word(4,self.indicator_data,0x000000DF)

            time.sleep(0.5)

            # lock native
            ret = self.__rblib.sysctrl(0x8000,0xdead)
            return True  # sysctrl 성공 시 True 반환
        except Exception as e:
            self.append_log("cause_critical_error : %s\n"%e)
            return False  # sysctrl 실패 시, False 반환

    def status_log(self, tag_id, logmsg):
        self.__logsockname = "/tmp/ndstatus"
        with self.__lock:
            now = datetime.datetime.today()
            timestr = "%04d-%02d-%02d %02d:%02d:%02d.%03d" % (now.year,
                now.month, now.day, now.hour, now.minute, now.second, now.microsecond/1000)
            outstr = "%s,%s,%s\n" % (timestr,tag_id,logmsg)
            try:
                self.__logsock.sendto(outstr, self.__logsockname)
            except Exception as e:
                self.append_log("status_log : %s\n"%e)
    
    def read_memory_io_word(self, word_addr):
        ret = self.__rblib.ioctrl(word_addr, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF)
        return ret

    def write_memory_io_word(self, word_addr, data, mask):
        ret = self.__rblib.ioctrl(word_addr, data, mask, 0xFFFFFFFF, 0xFFFFFFFF)
        return ret[0]

    def generate_indicator_data(self, status, code):
        str7seg = ""
        if status < self.SS_NERR:
            str7seg = self.SS_7seg[status]
        else:
            str7seg = self.SS_7seg[status] % code
        # print("[%s]" % str7seg)
        data1 = self.FONT7SEG[str7seg[0]]
        data2 = self.FONT7SEG[str7seg[1]]
        data3 = self.FONT7SEG[str7seg[2]]
        out_data = 0
        out_data |= (data1 & 0x0FF) << 8
        out_data |= (data2 & 0x0FF) << 16
        out_data |= (data3 & 0x0FF) << 24
        out_data |= 0x80808000
        return out_data
    # endregion


################################################################################################################
if __name__ == "__main__":
    socket_chk = socket_checker(sys.argv)
    ret = socket_chk.run()

    if ret == socket_chk.ret_status["Ping_OK"]:
        sys.exit(0)  # True
    else:
        sys.exit(7)  # False
